<?php

return [
    'name' => 'Placeringer',
    'all_states' => 'Alle stater',
    'abbreviation' => 'Forkortelse',
    'abbreviation_placeholder' => 'E.g: CA',
    'import_type' => [
        'country' => 'Land',
        'state' => 'Stat',
        'city' => 'By',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Land',
            'state' => 'Stat',
            'city' => 'By',
        ],
    ],
    'export' => [
        'total' => 'Samlede placeringer',
        'total_countries' => 'Samlede lande',
        'total_states' => 'Samlede stater',
        'total_cities' => 'Samlede byer',
        'description' => 'Eksporter dine placeringsdata som lande, stater og byer.',
        'import_type' => 'Placeringstype',
        'all_types' => 'Alle typer',
        'all_status' => 'Alle statusser',
        'use_chunked_export' => 'Brug chunked eksport',
        'use_chunked_export_helper' => 'Behandl data i mindre batches for at undgå hukommelsesproblemer med store datasæt.',
        'optimize_memory' => 'Optimer hukommelsesforbrug',
        'optimize_memory_helper' => 'Indlæs kun nødvendige kolonner og frigør hukommelse periodisk under eksporten.',
        'use_streaming' => 'Brug streaming-tilstand',
        'use_streaming_helper' => 'Stream data direkte til fil uden at indlæse alt i hukommelsen. Anbefales til meget store datasæt.',
        'streaming_enabled_title' => 'Streaming-tilstand aktiveret',
        'streaming_enabled_message' => 'Data vil blive streamet direkte til filen for optimal hukommelsesbrug.',
        'chunk_size' => 'Chunk-størrelse',
        'chunk_size_helper' => 'Antal poster, der skal behandles i hver batch. Lavere værdier bruger mindre hukommelse, men tager længere tid.',
        'recommended_range' => 'Anbefalet område',
        'optimal_range' => 'Optimal',
        'too_small_slow' => 'For lille (langsommere)',
        'too_large_timeouts' => 'For stor (kan få timeout)',
        'range_large_export' => '150-300 poster',
        'range_medium_export' => '200-500 poster',
        'range_small_export' => '300-700 poster',
        'large_dataset_title' => 'Stort datasæt registreret',
        'large_dataset_message' => 'Optimeret eksporttilstand aktiveret automatisk for bedre ydeevne.',
        'large_dataset_warning_title' => 'Anbefalinger til eksport af stort datasæt',
        'large_dataset_specific_message' => 'Du eksporterer :count placeringer. For optimal ydeevne anbefaler vi at bruge CSV-format med chunked eksport.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Anbefalet)',
        'chunk_label' => 'Chunk-størrelse',
        'chunk_recommended' => '150-300 poster',
        'time_label' => 'Anslået tid',
        'time_estimate' => '2-5 minutter',
        'pro_tip' => 'Pro-tip:',
        'pro_tip_message' => 'Du kan filtrere efter placeringstype (land/stat/by) for at eksportere specifikke data.',
        'medium_dataset_detected' => 'Mellemstort datasæt registreret',
        'medium_dataset_message' => 'Eksporterer :count placeringer. Eksporten bør være færdig inden for 1-2 minutter.',
        'excel_disabled_warning' => 'Excel-format anbefales ikke til store datasæt (:count+ poster). Brug CSV i stedet.',
    ],
    'import' => [
        'description' => 'Importer placeringsdata nemt fra tilgængelige data eller ved at uploade en CSV/Excel-fil.',
        'rules' => [
            'name' => 'Navnet på placeringen er obligatorisk og må ikke overstige 120 tegn.',
            'slug' => 'Sluggen af placeringen, hvis angivet, må ikke overstige 120 tegn.',
            'import_type' => 'Importtypen er obligatorisk og skal være en af de foruddefinerede værdier.',
            'order' => 'Rækkefølgen af placeringen, hvis angivet, skal være et positivt heltal mellem 0 og 127.',
            'abbreviation' => 'Forkortelsen af placeringen, hvis angivet, må ikke overstige 10 tegn.',
            'status' => 'Status for placeringen er obligatorisk og skal være en af de foruddefinerede værdier.',
            'country' => 'Landefeltet er obligatorisk, hvis importtypen er stat eller by.',
            'state' => 'Statsfeltet er obligatorisk, hvis importtypen er by.',
            'nationality' => 'Nationaliteten af placeringen, hvis angivet, må ikke overstige 120 tegn.',
        ],
    ],
];
