<?php

return [
    'name' => '商品',
    'description' => '商品設定を表示・更新します',
    'create' => '新しい商品',
    'create_product_type' => [
        'physical' => '新しい物理商品',
        'digital' => '新しいデジタル商品',
    ],
    'edit' => '商品を編集 - :name',
    'form' => [
        'name' => '名前',
        'name_placeholder' => '商品名（最大120文字）',
        'description' => '説明',
        'description_placeholder' => '商品の簡単な説明（最大400文字）',
        'categories' => 'カテゴリ',
        'content' => 'コンテンツ',
        'price' => '価格',
        'quantity' => '数量',
        'brand' => 'ブランド',
        'width' => '幅',
        'height' => '高さ',
        'weight' => '重量',
        'date' => [
            'start' => '開始日',
            'end' => '終了日',
        ],
        'image' => '画像',
        'collections' => '商品コレクション',
        'labels' => 'ラベル',
        'price_sale' => 'セール価格',
        'product_type' => [
            'title' => '商品タイプ',
        ],
        'product' => '商品',
        'total' => '合計',
        'sub_total' => '小計',
        'shipping_fee' => '送料',
        'discount' => '割引',
        'options' => 'オプション',
        'shipping' => [
            'height' => '高さ',
            'length' => '長さ',
            'title' => '配送',
            'weight' => '重量',
            'wide' => '幅',
        ],
        'barcode' => 'バーコード（ISBN、UPC、GTINなど）',
        'barcode_placeholder' => 'バーコードを入力',
        'cost_per_item' => '商品あたりのコスト',
        'cost_per_item_placeholder' => '商品あたりのコストを入力',
        'cost_per_item_helper' => '顧客にはこの価格は表示されません。',
        'price_includes_tax' => '価格に税金が含まれています',
        'price_includes_tax_helper' => '入力した価格にすでに税金が含まれている場合は、これをチェックしてください。システムは税額を除いて基本価格を計算します。',
        'stock' => [
            'allow_order_when_out' => 'この商品が在庫切れの時でも顧客の購入を許可する',
            'in_stock' => '在庫あり',
            'out_stock' => '在庫切れ',
            'title' => '在庫状況',
        ],
        'storehouse' => [
            'no_storehouse' => '倉庫管理なし',
            'storehouse' => '倉庫管理あり',
            'title' => '倉庫',
            'quantity' => '数量',
        ],
        'tax' => '税金',
        'taxes' => '税金',
        'taxes_helper' => 'デフォルトの税率は<a href=":url">設定 -> 税金</a>で設定されています。この商品に特定の税金が選択されていない場合、デフォルト税率が適用されます。この商品の税金を無効にするには、税金設定からデフォルト税率を削除してください。',
        'is_default' => 'デフォルト',
        'action' => 'アクション',
        'restock_quantity' => '再入庫数量',
        'remain' => '残り',
        'choose_discount_period' => '割引期間を選択',
        'cancel' => 'キャンセル',
        'no_results' => '結果がありません！',
        'value' => '値',
        'attribute_name' => '属性名',
        'add_more_attribute' => '属性を追加',
        'continue' => '続行',
        'add_new_attributes' => '新しい属性を追加',
        'add_new_attributes_description' => '新しい属性を追加することで、商品にサイズや色などの多くのオプションを持たせることができます。',
        'create_product_variations' => ':link で商品バリエーションを作成！',
        'tags' => 'タグ',
        'write_some_tags' => 'タグを書く',
        'variation_existed' => 'このバリエーションは既に存在します。',
        'no_attributes_selected' => '属性が選択されていません！',
        'added_variation_success' => 'バリエーションの追加が正常に完了しました！',
        'updated_variation_success' => 'バリエーションの更新が正常に完了しました！',
        'created_all_variation_success' => 'すべてのバリエーションの作成が正常に完了しました！',
        'updated_product_attributes_success' => '商品属性の更新が正常に完了しました！',
        'stock_status' => '在庫状況',
        'auto_generate_sku' => 'SKUを自動生成？',
        'featured_image' => '注目画像（任意）',
        'product_id' => '商品ID',
        'price_sale_percent_helper' => '元の価格から:percent割引。',
        'minimum_order_quantity' => '最小注文数量',
        'minimum_order_quantity_helper' => '注文する最小数量。値が0の場合、制限はありません。',
        'maximum_order_quantity' => '最大注文数量',
        'maximum_order_quantity_helper' => '注文する最大数量。値が0の場合、制限はありません。',
        'video' => '動画',
        'video_file' => 'ファイル',
        'video_url' => 'または外部動画URL',
        'video_url_help' => 'YouTubeまたはVimeoの動画URLを入力',
        'enter_video_url' => '動画URLを入力',
        'video_thumbnail' => '動画サムネイル',
        'video_thumbnail_help' => '動画のサムネイルを選択してください。選択されていない場合、可能であれば動画URLから自動的に取得されます。',
        'barcode_existed' => 'このバーコードは他の商品で使用されています。別のバーコードを入力してください。',
        'barcode_helper' => '各商品で一意である必要があります。',
        'is_new_until' => '新着終了日',
        'is_new_until_helper' => 'この商品が「新着」としてマークされる日付を設定します。日付に基づいて新着としてマークしない場合は空白のままにしてください。',
    ],
    'price' => '価格',
    'quantity' => '数量',
    'type' => 'タイプ',
    'image' => 'サムネイル',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'バリエーションSKU',
    'brand' => 'ブランド',
    'cannot_delete' => '商品を削除できませんでした',
    'product_deleted' => '商品が削除されました',
    'product_collections' => '商品コレクション',
    'products' => '商品',
    'menu' => '商品',
    'control' => [
        'button_add_image' => '画像を追加',
    ],
    'price_sale' => 'セール価格',
    'price_group_title' => '商品価格の管理',
    'store_house_group_title' => '倉庫の管理',
    'shipping_group_title' => '配送の管理',
    'overview' => '概要',
    'attributes' => '属性',
    'product_has_variations' => '商品にバリエーションがあります',
    'manage_products' => '商品管理',
    'add_new_product' => '新しい商品を追加',
    'start_by_adding_new_product' => '新しい商品を追加することから始めましょう。',
    'edit_this_product' => 'この商品を編集',
    'delete' => '削除',
    'related_products' => '関連商品',
    'cross_selling_products' => 'クロスセリング商品',
    'up_selling_products' => 'アップセリング商品',
    'grouped_products' => 'グループ商品',
    'search_products' => '商品を検索',
    'selected_products' => '選択された商品',
    'edit_variation_item' => '編集',
    'variations_box_description' => 'バリエーションの属性を追加/削除するには「属性を編集」をクリックするか、バリエーションを追加するには「新しいバリエーションを追加」をクリックしてください。',
    'save_changes' => '変更を保存',
    'continue' => '続行',
    'edit_attribute' => '属性を編集',
    'select_attribute' => '属性を選択',
    'add_new_variation' => '新しいバリエーションを追加',
    'edit_variation' => 'バリエーションを編集',
    'generate_variations' => 'バリエーションを生成',
    'generate_variations_confirmation' => 'この商品のバリエーションを生成してもよろしいですか？',
    'delete_variation' => 'バリエーションを削除？',
    'delete_variation_confirmation' => 'このバリエーションを削除してもよろしいですか？この操作は元に戻せません。',
    'delete_variations_confirmation' => 'これらのバリエーションを削除してもよろしいですか？この操作は元に戻せません。',
    'product_create_validate_name_required' => '商品名を入力してください',
    'product_create_validate_sale_price_max' => '割引は元の価格より少なくなければなりません',
    'product_create_validate_cost_per_item_max' => '商品あたりのコストは元の価格より少なくなければなりません',
    'product_create_validate_sale_price_required_if' => 'プロモーションをスケジュールする場合は割引を入力する必要があります',
    'product_create_validate_end_date_after' => '終了日は開始日より後でなければなりません',
    'product_create_validate_start_date_required_if' => 'スケジュールが選択されている場合、割引開始日は空白にできません',
    'product_create_validate_sale_price' => 'スケジュールが選択されている場合、割引は空白にできません',
    'stock_statuses' => [
        'in_stock' => '在庫あり',
        'out_of_stock' => '在庫切れ',
        'on_backorder' => 'バックオーダー中',
    ],
    'stock_status' => '在庫状況',
    'processing' => '処理中...',
    'delete_selected_variations' => '選択されたバリエーションを削除',
    'delete_variations' => 'バリエーションを削除',
    'category' => 'カテゴリ',
    'categories' => 'カテゴリー',
    'tags' => 'タグ',
    'product_price_flash_sale_warning' => 'この商品はフラッシュセール<strong>:name</strong>中のため、価格は<strong>:price</strong>です。',
    'product_price_discount_warning' => 'この商品は割引<strong>:name</strong>中のため、価格は<strong>:price</strong>です。',
    'product_image' => '商品画像',
    'product_name' => '商品名',
    'product_link' => '商品リンク',
    'types' => [
        'physical' => '物理',
        'digital' => 'デジタル',
    ],
    'digital_attachments' => [
        'title' => 'デジタル添付ファイル',
        'add' => '添付ファイルを追加',
        'file_name' => 'ファイル名',
        'file_size' => 'ファイルサイズ',
        'unsaved' => '未保存',
        'add_external_link' => '外部リンクを追加',
        'enter_file_name' => 'ファイル名を入力',
        'enter_external_link_download' => '外部ダウンロードリンクを入力',
        'enter_file_size' => 'ファイルサイズを入力',
        'external_link_download' => '外部ダウンロードリンク',
        'generate_license_code_after_purchasing_product' => 'この商品のライセンスコード割り当てを有効にする',
        'notify_attachment_updated' => '添付ファイルが更新された際に顧客にメールを送信',
    ],
    'license_codes' => [
        'title' => 'ライセンスコード',
        'add' => 'ライセンスコードを追加',
        'back' => '商品に戻る',
        'edit' => 'ライセンスコードを編集',
        'generate' => 'コードを生成',
        'manage_codes' => 'ライセンスコードを管理',
        'management' => 'ライセンスコード管理',
        'variation_breadcrumb' => 'バリエーション: :name',
        'variation_label' => '商品バリエーション',
        'variation_specific_note' => 'これらのライセンスコードはこの商品バリエーション専用です。このバリエーションを購入した顧客は、このプールからコードを受け取ります。',
        'main_product_note' => 'この商品にはバリエーションがあります。各バリエーションは独自のライセンスコードを持つことができ、バリエーションにコードがない場合は、顧客はこのメイン商品プールからコードを受け取ります。',
        'code' => 'ライセンスコード',
        'codes' => 'ライセンスコード',
        'status' => 'ステータス',
        'assigned_at' => '割り当て日時',
        'status_available' => '利用可能',
        'status_used' => '使用済み',
        'statuses' => [
            'available' => '利用可能',
            'used' => '使用済み',
        ],
        'no_codes' => 'ライセンスコードが見つかりません。コードを追加するか、自動生成してください。',
        'no_codes_warning_title' => 'ライセンスコードがありません！',
        'no_codes_warning_message' => 'この商品は「リストから選択」に設定されていますが、利用可能なライセンスコードがありません。この商品を購入した顧客は、代わりに自動生成されたコードを受け取ります。適切な機能のためにライセンスコードを追加してください。',
        'no_codes_auto_generate' => 'この商品はライセンスコードを自動生成するように設定されています。手動でのコードは不要です。',
        'used_code_no_actions' => '使用済みコード - アクションはありません',
        'created_successfully' => 'ライセンスコードが正常に作成されました！',
        'updated_successfully' => 'ライセンスコードが正常に更新されました！',
        'deleted_successfully' => 'ライセンスコードが正常に削除されました！',
        'generated_successfully' => ':count 個のライセンスコードが正常に生成されました！',
        'duplicates_skipped' => ':count 個の重複コードがスキップされました。',
        'generation_incomplete' => '警告: 重複の競合により、リクエストされた :requested 個のうち :generated 個のコードのみを生成できました。',
        'cannot_edit_used_code' => '使用済みライセンスコードは編集できません。',
        'cannot_delete_used_code' => '使用済みライセンスコードは削除できません。',
        'show_all' => 'すべて表示',
        'show_less' => '少なく表示',
        'more' => 'その他',
        'used_codes_hidden' => ':count 個の使用済みライセンスコードが非表示になっています。ライセンスコード管理ページですべてのコードを確認できます。',
        'low_stock_title' => 'ライセンスコード在庫不足',
        'low_stock_message' => 'ライセンスコードがあと :count 個しか残っていません。不足を防ぐためにコードを追加することを検討してください。',
        'out_of_stock_title' => 'ライセンスコード在庫切れ！',
        'out_of_stock_message' => '利用可能なライセンスコードがありません。コードを追加するまで、顧客は自動生成されたコードを受け取ります。',
        'type' => [
            'title' => 'ライセンスコード割り当て方法',
            'auto_generate' => '自動生成（システムが自動的にコードを生成）',
            'pick_from_list' => 'リストから選択（事前入力されたコードを使用）',
            'description' => '顧客がこの商品を購入した際のライセンスコードの割り当て方法を選択してください。',
        ],
        'generate_modal' => [
            'title' => 'ライセンスコードを生成',
            'quantity' => '数量',
            'format' => 'フォーマット',
            'custom_pattern' => 'カスタムパターン',
            'pattern_help' => '数字には#、大文字にはA、小文字にはaを使用',
            'generate' => '生成',
        ],
        'errors' => [
            'feature_not_enabled' => 'ライセンスコード機能が有効になっていません。Ecommerce設定 > デジタル商品で有効にしてください。',
            'digital_products_not_enabled' => 'デジタル商品が有効になっていません。まずデジタル商品サポートを有効にしてください。',
            'product_not_found' => '商品が見つかりません。',
            'not_digital_product' => 'ライセンスコードはデジタル商品でのみ利用可能です。この商品は物理商品として設定されています。',
            'license_codes_not_enabled_for_product' => 'この商品のライセンスコード管理が有効になっていません。商品設定で「商品購入後にライセンスコードを生成」を有効にしてください。',
            'cannot_add_codes_auto_generate' => '自動生成に設定された商品にライセンスコードを手動で追加することはできません。まずライセンスコードタイプを「リストから選択」に変更してください。',
            'cannot_generate_codes_auto_generate' => '自動生成に設定された商品のライセンスコードを手動で生成することはできません。まずライセンスコードタイプを「リストから選択」に変更してください。',
        ],
        'copied' => 'ライセンスコードがクリップボードにコピーされました！',
    ],
    'this_action_will_reload_page' => 'この操作によりページがリロードされ、データが更新されます！',
    'select' => '選択',
    'set_this_variant_as_default' => 'このバリエーションをデフォルトに設定',
    'download' => 'ダウンロード',
    'cross_sell_price_type' => [
        'title' => '価格タイプ',
        'fixed' => '固定',
        'percent' => 'パーセント',
    ],
    'cross_sell_help' => [
        'price' => '価格',
        'price_description' => '元の価格から削減したい金額を入力してください。例：元の価格が$100の場合、20と入力すると価格は$80になります。',
        'type' => '* タイプフィールド',
        'type_description' => '割引タイプを選択：固定（特定の金額を削減）またはパーセント（パーセンテージで削減）。',
    ],
    'apply_for_all_variations' => 'すべてのバリエーションに適用',
    'export' => [
        'description' => '商品データをCSVまたはExcelファイルにエクスポートします。',
        'total_items' => '総アイテム数',
        'total_products' => '総商品数',
        'total_variations' => '総バリエーション数',
        'advanced_options' => '詳細オプション',
        'use_chunked_export' => 'チャンクエクスポートを使用',
        'use_chunked_export_helper' => '大きなデータセットを効率的に処理するためにデータをチャンクで処理',
        'include_variations' => '商品バリエーションを含める',
        'include_variations_helper' => 'メイン商品と一緒に商品バリエーションをエクスポート',
        'optimize_memory' => 'メモリ使用量を最適化',
        'optimize_memory_helper' => '非常に大きなエクスポートのためのメモリ最適化を有効にする',
        'chunk_size' => 'チャンクサイズ',
        'chunk_size_helper' => '一度に処理する商品数（50-5000）',
        'use_streaming' => 'ストリーミングエクスポートを使用',
        'use_streaming_helper' => '非常に大きなデータセットのストリーミングを有効にする（10,000アイテム超で自動有効）',
        'large_dataset_warning_title' => '大規模商品カタログが検出されました',
        'large_dataset_warning_message' => 'カタログには :count アイテムが含まれています。大きなサイズのため、最適なパフォーマンスのために一部のエクスポートオプションが最適化されています。',
        'large_dataset_specific_message' => ':count 商品については、ストリーミングを有効にしたCSVフォーマットを使用してください。システムはタイムアウトやメモリ問題なしに大規模商品カタログを効率的に処理できます。',
        'format_label' => 'フォーマット',
        'csv_recommended' => 'CSV（必須）',
        'chunk_label' => '処理',
        'chunk_recommended' => '300商品/バッチ',
        'time_label' => '予想時間',
        'time_estimate' => '1-3分',
        'pro_tip' => 'プロのヒント:',
        'pro_tip_message' => 'ブラウザが読み込みインジケータを表示していても、エクスポートは続行されます。開始すると、ダウンロードが自動的に始まります。',
        'large_dataset_tip_1' => 'Excelフォーマットは無効になっています - より高速で信頼性の高いエクスポートのためにCSVフォーマットを使用してください',
        'large_dataset_tip_2' => 'タイムアウトを防ぐためにストリーミングモードが自動的に有効になりました',
        'large_dataset_tip_3' => 'エクスポートプロセスは、サーバーによって1-3分かかる場合があります',
        'large_dataset_recommendation' => '推奨: 最適なパフォーマンスのために200-500チャンクサイズでCSVフォーマットを使用してください。',
        'excel_disabled_for_large_export' => '10,000アイテム超のカタログではExcelフォーマットは利用できません',
        'streaming_auto_enabled' => '大規模データセットでの最適なパフォーマンスのためにストリーミングモードが自動的に有効になりました。',
        'streaming_enabled_title' => '大規模エクスポート用に最適化',
        'streaming_enabled_message' => 'メモリ問題なしでスムーズなエクスポートを確保するためにストリーミングモードがアクティブです。',
        'use_multi_file' => 'マルチファイルエクスポートを使用',
        'use_multi_file_helper' => '非常に大きなデータセットの場合、エクスポートをZIPにパッケージ化された複数のファイルに分割します',
        'multi_file_enabled_title' => 'マルチファイルエクスポート有効',
        'multi_file_enabled_message' => '最適なパフォーマンスのために、エクスポートはZIPにパッケージ化された:countファイルに分割されます。',
        'records_per_file' => 'ファイルあたりのレコード数',
        'records_per_file_helper' => 'マルチファイルエクスポートを使用する場合の各ファイルのレコード数',
        'estimated_files' => '推定ファイル数',
        'recommended_range' => '推奨範囲',
        'range_large_export' => '200-500アイテム',
        'range_medium_export' => '300-800アイテム',
        'range_small_export' => '500-1000アイテム',
        'export_progress' => 'エクスポート進行状況',
        'preparing_export' => 'エクスポートを準備中...',
        'items_processed' => ':count アイテムが処理されました',
        'estimated_time_calculating' => '予想時間: 計算中...',
        'medium_dataset_detected' => '中規模データセットが検出されました',
        'medium_dataset_message' => ':count 商品をエクスポートしています。より良いパフォーマンスのためにチャンクエクスポートの使用を検討してください。',
        'optimal_range' => '最適範囲',
        'too_small_slow' => '小さすぎ - 遅い可能性',
        'too_large_timeouts' => '大きすぎ - タイムアウトの可能性',
        'excel_disabled_warning' => '大規模エクスポート（:count アイテム）でExcelフォーマットが無効',
        'starting_export' => 'エクスポート開始中...',
        'processing_data' => 'データ処理中...',
        'finalizing_export' => 'エクスポート終了処理中...',
        'items_processed_suffix' => 'アイテムが処理されました',
        'estimated_time_prefix' => '予想時間:',
        'seconds_remaining' => '秒残り',
        'export_completed' => 'エクスポート完了！',
        'download_starting' => 'ダウンロード開始中...',
    ],
    'import' => [
        'description' => 'CSVまたはExcelファイルから商品データをインポートします。',
        'rules' => [
            'in' => ':attribute は定義された値のいずれかである必要があります: :values',
            'required_string_max' => ':attribute は必須で、最大 :max 文字の文字列である必要があります。',
            'nullable_string' => ':attribute は空のままにするか、提供される場合は文字列である必要があります。',
            'nullable_string_max' => ':attribute は空のままにするか、提供される場合は最大 :max 文字の文字列である必要があります',
            'nullable_bool' => ':attribute は空のままにするか、提供される場合はブール値である必要があります。',
            'nullable_numeric_min' => ':attribute は空のままにするか、提供される場合は非負の数値である必要があります。',
            'nullable_numeric_min_max' => ':attribute は空白のままにするか、提供される場合は :min と :max の間の数値である必要があります。',
            'nullable_array' => ':attribute は空のままにするか、指定される場合は配列として提供される必要があります。',
            'nullable_date_required_if' => ':attribute は空のままにするか、提供される場合は有効な日付である必要があり、:required が指定されている場合は必須です。',
            'nullable_date_after' => ':attribute は空のままにするか、提供される場合は :after より後の有効な日付である必要があります。',
        ],
        'updated_message' => ':count 商品が正常に更新されました！',
    ],
    'import_products_intro' => 'またはCSV/Excelから商品をインポート',
    'select_attributes' => 'バリエーションを作成する属性を選択:',
    'all' => 'すべて',
    'copy' => 'コピー',
    'product_translations' => '商品翻訳',
    'view' => '製品を表示 - :name',
    'product_information' => '製品情報',
    'total_views' => '総閲覧数',
    'total_orders' => '完了した注文',
    'total_sold' => '総販売数',
    'total_revenue' => '総収益',
    'pending_orders' => '保留中の注文',
    'pending_revenue' => '保留中の収益',
    'conversion_rate' => 'コンバージョン率',
    'total_reviews' => 'レビュー総数',
    'average_rating' => '平均評価',
    'views_by_date' => '日付別閲覧数（過去30日間）',
    'recent_orders' => '最近の注文',
    'no_views_data' => '過去30日間の閲覧データがありません。',
    'no_orders' => 'まだ注文がありません。',
    'date' => '日付',
    'views' => '閲覧数',
    'total' => '合計',
    'view_on_frontend' => 'フロントエンドで表示',
    'select_attribute' => ':nameを選択',
    'all_categories' => 'すべてのカテゴリー',
    'brands' => 'ブランド',
    'browse_products' => '商品を閲覧',
    'sku_1' => 'SKU:',
    'select_products_to_return' => '返品する商品を選択',
    'show_only_discounted_products' => '割引商品のみ表示',
    'specification' => '仕様',
    'download_product_with_external_links' => '外部リンク付きの商品":name"をダウンロード',
    'number_product_available_singular' => ':number個の商品が利用可能',
    'number_products_available_plural' => ':number個の商品が利用可能',
];
