<?php

use Botble\Theme\Facades\Theme;
use Illuminate\Support\Facades\Route;

Route::group(['namespace' => 'Theme\Agon\Http\Controllers', 'middleware' => ['web', 'core']], function (): void {
    Route::group(apply_filters(BASE_FILTER_GROUP_PUBLIC_ROUTE, []), function (): void {
        Route::group([
            'prefix' => 'ajax',
            'as' => 'public.ajax.',
        ], function (): void {
            Route::get('search', [
                'uses' => 'AgonController@getSearch',
                'as' => 'search',
            ]);
            Route::controller('EcommerceController')->group(function (): void {
                Route::get('search-products', [
                    'uses' => 'ajaxSearchProducts',
                    'as' => 'search-products',
                ]);

                Route::get('products', [
                    'uses' => 'ajaxGetProducts',
                    'as' => 'products',
                ]);

                Route::get('featured-product-categories', [
                    'uses' => 'ajaxGetFeaturedProductCategories',
                    'as' => 'featured-product-categories',
                ]);

                Route::get('featured-brands', [
                    'uses' => 'ajaxGetFeaturedBrands',
                    'as' => 'featured-brands',
                ]);

                Route::get('get-flash-sale/{id}', [
                    'uses' => 'ajaxGetFlashSale',
                    'as' => 'get-flash-sale',
                ]);

                Route::get('product-categories/products', [
                    'uses' => 'ajaxGetProductsByCategoryId',
                    'as' => 'product-category-products',
                ]);

                Route::get('featured-products', [
                    'uses' => 'ajaxGetFeaturedProducts',
                    'as' => 'featured-products',
                ]);

                Route::get('cart', [
                    'uses' => 'ajaxCart',
                    'as' => 'cart',
                ]);

                Route::get('quick-view/{id?}', [
                    'uses' => 'ajaxGetQuickView',
                    'as' => 'quick-view',
                ]);

                Route::get('related-products/{id}', [
                    'uses' => 'ajaxGetRelatedProducts',
                    'as' => 'related-products',
                ]);

                Route::get('recently-viewed-products', [
                    'uses' => 'ajaxGetRecentlyViewedProducts',
                    'as' => 'recently-viewed-products',
                ]);
            });
        });
    });
});

Theme::routes();
